#!/usr/bin/perl
push(@INC,"D:/inetpub/hosted/geeksoft.com/fed/");
require('gfed.pl');

use CGI;
$cgi = new CGI;
 
if($ARGV[0] eq ''){
  error("leagueID not specified");
}

$leagueid = $ARGV[0];
openleague($leagueid);
openrp($leagueid);

$login = $cgi->param('login');
$pass = $cgi->param('pass');

if($ARGV[1] eq 'view'){
  showlist();
  exit;
}

if($ARGV[1] eq 'view'){
  showlist();
}elsif($ARGV[1] eq 'post'){
  
  if($login eq ''){
    error("No user was specified");
    exit;
  }

  if($roster{$login}[$c_pass] ne encrypt($pass)){
    error("Invalid Password");
    exit;
  }

  if(exists($roster{$login}) == 0){
    error("A wrestler with this login does not exist in this league");
    exit;
  }

  if($roster{$login}[$c_postedrp] == 3){
    error("Three roleplays are currently posted for this wrestler");
    exit;
  }
  $msg = $cgi->param('msg');
  $title = $cgi->param('title');

  $title =~ s/</&lt;/g;
  $title =~ s/>/&gt;/g;
  $title =~ s/\r\n/<br>/g;
  $title =~ s/\t/    /g;

  $msg =~ s/</&lt;/g;
  $msg =~ s/>/&gt;/g;
  $msg =~ s/\r\n/<br>/g;
  $msg =~ s/\t/    /g;
  
  $key = $login."_$roster{$login}[$c_postedrp]";
  $rp{$key}[0] = $title;
  $rp{$key}[1] = $msg;
  $rp{$key}[2] = time();
  $rp{$key}[3] = 0;
  $roster{$login}[$c_postedrp]++;
  saveleague($leagueid);
  saverp($leagueid);
  printpage($login,"Your Roleplay was posted");
}elsif($ARGV[1] eq 'form'){

  if($roster{$login}[$c_pass] ne encrypt($pass)){
    error("Invalid Password");
    exit;
  }

  printform();
}elsif($ARGV[1] eq 'reset' and $login eq 'admin'){

  if($roster{'admin'}[$l_pass] ne encrypt($pass)){
    error("Invalid Password");
    exit;
  }

  @keys = keys(%roster);
  foreach $key (@keys){
      $roster{"$key"}[$c_postedrp] = 0;
  }
  @keys = keys(%rp);
  foreach $key (@keys){
    delete($rp{$key});
  }
  saveleague($leagueid);
  saverp($leagueid);
  printadmin();
}elsif($ARGV[1] eq 'grade' and $login eq 'admin'){

  if($roster{'admin'}[$l_pass] ne encrypt($pass)){
    error("Invalid Password");
    exit;
  }

  $rp = $cgi->param('rp');
  $points = $cgi->param('grade');
  ($user,$num) = split('_',$rp);
  if(exists($roster{$user})){
    $roster{$user}[$c_points] = $roster{$user}[$c_points] + $points;
    $rp{$rp}[3] = 1;
    saveleague($leagueid);
    saverp($leagueid);
  }
  showlist();
}else{
  $msgnum = $ARGV[1];
  showmsg($msgnum);
}

sub printform{
  my($font) = $roster{'admin'}[$l_fcolor];
my($table) = $roster{'admin'}[$l_tcolor];
my($bgcolor) = $roster{'admin'}[$l_bgcolor];
my($link) = $roster{'admin'}[$l_lcolor];
my($background) = $roster{'admin'}[$l_background];

printheader('');
print <<EOF;
 <TABLE BGCOLOR="$table">
 <TR>
   <TD ALIGN="left"> 
   <FONT FACE="verdana, arial" SIZE="2" COLOR="$font">
   <CENTER>
   Roleplay as:<br>
   <b>$roster{$login}[$c_name]</b><p>
   </CENTER>
   <FORM METHOD="post" ACTION="$script_path/rpboard.cgi?$leagueid+post">
   <INPUT TYPE="hidden" NAME="login" VALUE="$login">
   <INPUT TYPE="hidden" NAME="pass" VALUE="$pass">
   Title:<br>
   <INPUT NAME="title" TYPE="text" SIZE="35"><br>
   Roleplay:<br>
   <TEXTAREA NAME="msg" rows="13" cols="50"></TEXTAREA><br>
   <CENTER>
   <INPUT TYPE="submit" VALUE="Submit this Roleplay">
   </CENTER>
   </FORM>
   </FONT>
   </TD>
 </TR>
 </TABLE>
</CENTER>
</BODY>
</HTML>
EOF
}

sub showmsg{
  $msgnum = shift(@_);
  if(exists($rp{$msgnum}) == 0){
    error("A roleplay has not been posted for this wrestler");
    exit;
  }
  ($user,$num) = split("_",$msgnum);
my($font) = $roster{'admin'}[$l_fcolor];
my($table) = $roster{'admin'}[$l_tcolor];
my($bgcolor) = $roster{'admin'}[$l_bgcolor];
my($link) = $roster{'admin'}[$l_lcolor];
my($background) = $roster{'admin'}[$l_background];

printheader('');
print <<EOF;
 <TABLE WIDTH="80%" BGCOLOR="$table">
 <TR>
   <TD ALIGN="left"> 
   <FONT FACE="verdana, arial" SIZE="2" COLOR="$font">
   <CENTER>
     <b>$rp{$msgnum}[0]</b><br>
     by<br>
     <b>$roster{$user}[$c_name]</b><p>
   </CENTER>
   $rp{$msgnum}[1]

   <CENTER>
   </FONT>
EOF

if($rp{$msgnum}[3] == 0){
print <<EOF;
   <FONT FACE="verdana, arial" SIZE="1" COLOR="$font">
   <FORM METHOD="post" ACTION="$script_path/rpboard.cgi?$leagueid+grade">
   <INPUT TYPE="hidden" NAME="login" VALUE="admin">
   <INPUT TYPE="hidden" NAME="rp" VALUE="$msgnum">
   Admin Password:<br>
   <INPUT TYPE="password" NAME="pass" SIZE="7" MAXLENGTH="10"><br>
   Grade: (0-5)<br>
   <INPUT TYPE="text" NAME="grade" SIZE="1" MAXLENGTH="1"><br>
   <INPUT TYPE="submit" VALUE="Submit Grade">
   </FORM>
   </FONT>
   </CENTER>
   </FONT>
EOF
}

print <<EOF;
   </TD>
 </TR>
 </TABLE>
</BODY>
</HTML>
EOF

}

sub showlist{

my($font) = $roster{'admin'}[$l_fcolor];
my($table) = $roster{'admin'}[$l_tcolor];
my($bgcolor) = $roster{'admin'}[$l_bgcolor];
my($link) = $roster{'admin'}[$l_lcolor];
my($background) = $roster{'admin'}[$l_background];

printheader('');
print <<EOF;
 <TABLE WIDTH="80%" BGCOLOR="$table">
 <TR>
   <TD ALIGN="left"> 
   <FONT FACE="verdana, arial" SIZE="2" COLOR="$font">
EOF

  if($login eq 'admin'){
    print "<center><b>[</b><a href=$script_path/login.cgi?$leagueid>Login Screen</a><b>]</b></center><p>\n";
  }elsif(($cgi->cookie('login') ne '' or $login) and ($cgi->cookie('pass') ne '' or $pass)){
    print "<center><b>[</b><a href=$script_path/login.cgi?$leagueid+login>User Page</a><b>]</b></center><p>\n";
  }

  @keys = sort {$rp{$b}[2] <=> $rp{$a}[2]} keys(%rp);
  foreach $key (@keys){
    ($user,$num) = split("_",$key);
    print "<li> <a href=$script_path/rpboard.cgi?$leagueid+$key>$rp{$key}[0]</a> - $roster{$user}[$c_name] ";
    if($rp{$key}[3] == 1){
      print "<FONT FACE=\"verdana, arial\" SIZE=\"2\" COLOR=\"$link\"><b><i>Graded</i></b></FONT>";
    }
    print "\n";
  }
print <<EOF;
   </FONT>
   </TD>
  </TR>
  </TABLE>
</CENTER>
</BODY>
</HTML>
EOF
}

sub openrp{
  my($lid) = shift(@_);
  my($login);

  open(FILE,"$file_path$lid.rp") or error("Could not open Roleplay file: $lid.rp"),exit;

  while(<FILE>){
    $line = $_;
    chomp($line);
    if(length($line) > 5){
      ($login,$title,$msg,$time,$graded) = split(/\t/,$line);
      $rp{$login}[0] = $title;
      $msg =~ s/\|/\n/g;
      $rp{$login}[1] = $msg;
      $rp{$login}[2] = $time;
      $rp{$login}[3] = $graded
    }
  }
  close(FILE);
}

sub saverp{
  my($lid) = shift(@_);
  my($login);

  open(FILE,">".$file_path."$lid.rp") or error("Could not open Roleplay file"),exit;

  @keys = keys(%rp);
  foreach $key (@keys){
    $rp{$key}[1] =~ s/\n/\|/g;
    print FILE "$key\t$rp{$key}[0]\t$rp{$key}[1]\t$rp{$key}[2]\t$rp{$key}[3]\n";
  }
  close(FILE);
}
